#include <maps/wikimap/mapspro/libs/sender/include/email_template_params.h>
#include <maps/wikimap/mapspro/libs/sender/include/gateway.h>
#include <maps/wikimap/mapspro/libs/sender/include/config.h>
#include <maps/libs/json/include/value.h>
#include <iostream>

using namespace std;
using namespace maps::wiki::sender;
using namespace maps::common;
using namespace maps::json;

int main()
{
    // Sending email
    //
    {
        std::string endpoint = "test.sender.yandex-team.ru";

        Credentials credentials;
        credentials.userId = "c5d5c3b85ee6484fbdabd5b04324e545";
        credentials.accountSlug = "nmap";

        Gateway gateway(endpoint, credentials, RetryPolicy());

        auto mailParams = EmailTemplateParams::fromDict({{"username", "Dimok"}});
        auto res = gateway.sendToEmail("4P36QJK2-80R", "miror@yandex-team.ru", mailParams);
        cout << "Send result: " << res << endl;
    }

    // Using new json config
    //
    {
        auto config = Config::fromJson(Value::fromFile("config.json"));
        cout << "Credentials accountSlug: " << config.credentials.accountSlug << endl;
        const auto& campaigns = config.campaignSlugs;
        cout << "Vec ru slug: " << campaigns.getLocalizedByName("vec").slugs.getForLang("ru") << endl;
        cout << "Edits achieve 50 en slug: " << campaigns.getAchieveEdits().getCampaignSlug(50, "en") << endl;
    }
}
