#include <maps/wikimap/mapspro/libs/sender/include/campaigns.h>
#include "json_util.h"

namespace maps::wiki::sender {

LocalizedCampaign LocalizedCampaign::fromJson(const json::Value& json)
{
    assertJsonObjectHasFields(json, {"name", "slugs"});

    LocalizedCampaign res;
    res.name = json["name"].as<std::string>();
    res.slugs = LocalizedString::fromJson(json["slugs"]);
    return res;
}


NotExistingCampaignError::NotExistingCampaignError(const std::string& campaign) :
    RuntimeError("Campaign '" + campaign + "' doesn't exist")
{}


CampaignsSlugs::CampaignsSlugs(
    NameToLocalizedCampaign localizedCampaigns,
    CampaignAchieveEdits campaignAchieveEdits)
    : localizedCampaigns_(std::move(localizedCampaigns))
    , campaignAchieveEdits_(std::move(campaignAchieveEdits))
{}

CampaignsSlugs CampaignsSlugs::fromJson(const json::Value& json)
{
    ASSERT(json.isArray());

    NameToLocalizedCampaign localizedCampaigns;
    CampaignAchieveEdits campaignAchieveEdits;

    for (const auto& entity : json) {
        ASSERT(entity.isObject());
        auto campaignName = entity["name"].as<std::string>();

        if (campaignName == "achieve-edits-count") {
            campaignAchieveEdits = CampaignAchieveEdits::fromJson(entity);
        } else {
            auto localizedCampaign = LocalizedCampaign::fromJson(entity);
            localizedCampaigns.insert({
                {localizedCampaign.name, localizedCampaign}
            });
        }
    }

    return CampaignsSlugs(
        std::move(localizedCampaigns),
        std::move(campaignAchieveEdits)
    );
}

bool CampaignsSlugs::isLocalizedExists(const std::string& name) const
{
    return localizedCampaigns_.count(name);
}

const LocalizedCampaign& CampaignsSlugs::getLocalizedByName(const std::string& name) const
{
    if (!isLocalizedExists(name)) {
        throw NotExistingCampaignError("name");
    }
    return localizedCampaigns_.at(name);
}

const CampaignAchieveEdits& CampaignsSlugs::getAchieveEdits() const
{
    return campaignAchieveEdits_;
}

}  // namespace maps::wiki::sender
