#include <maps/wikimap/mapspro/libs/sender/include/config.h>
#include "json_util.h"

namespace {

const std::string DEFAULT_CONFIG_PATH =
    "/etc/yandex/maps/wiki/sender/config.json";

} // anon namespace

namespace maps::wiki::sender {

Credentials Credentials::fromJson(const json::Value& json)
{
    assertJsonObjectHasFields(json, {"user-id", "account-slug"});

    Credentials res;
    res.userId = json["user-id"].as<std::string>();
    res.accountSlug = json["account-slug"].as<std::string>();
    return res;
}


ConstantParams ConstantParams::fromJson(const json::Value& json)
{
    assertJsonObjectHasFields(
        json,
        {
            "maps-url", "nmaps-url", "feedback-url",
            "club-url", "unsubscribe-url-template"
        }
    );

    ConstantParams res;
    res.mapsUrl = LocalizedString::fromJson(json["maps-url"]);
    res.nmapsUrl = LocalizedString::fromJson(json["nmaps-url"]);
    res.feedbackUrl = LocalizedString::fromJson(json["feedback-url"]);
    res.clubUrl = LocalizedString::fromJson(json["club-url"]);
    res.unsubscribeUrlTemplate = LocalizedString::fromJson(json["unsubscribe-url-template"]);
    return res;
}


Config Config::fromJson(const json::Value& json)
{
    assertJsonObjectHasFields(
        json,
        {"credentials", "endpoint", "campaign-slugs", "constant-params"}
    );

    Config res;
    res.credentials = Credentials::fromJson(json["credentials"]);
    res.endPoint = json["endpoint"].as<std::string>();
    res.campaignSlugs = CampaignsSlugs::fromJson(json["campaign-slugs"]);
    res.constantParams = ConstantParams::fromJson(json["constant-params"]);
    return res;
}

Config loadDefaultConfig()
{
    return Config::fromJson(json::Value::fromFile(DEFAULT_CONFIG_PATH));
}

} // namespace maps::wiki::sender
