#include <maps/wikimap/mapspro/libs/sender/include/email_template_params.h>

#include <maps/libs/json/include/builder.h>
#include <maps/libs/json/include/std.h>
#include <maps/libs/json/include/value.h>

namespace maps::wiki::sender {

namespace {

std::string
eraseSchema(const std::string& url)
{
    for (const std::string& prefix: {"http://", "https://"}) {
        if (url.starts_with(prefix)) {
            return url.substr(prefix.size());
        }
    }
    return url;
}

} // namespace

EmailTemplateParams::EmailTemplateParams(
        std::map<std::string, std::string> dict)
        : dict_(std::move(dict))
{}

EmailTemplateParams
EmailTemplateParams::fromDict(std::map<std::string, std::string> dict)
{
    return EmailTemplateParams(std::move(dict));
}

EmailTemplateParams
EmailTemplateParams::fromJson(const std::string& json)
{
    auto dict = static_cast<decltype(dict_)&&>(json::Value::fromString(json));
    return EmailTemplateParams(std::move(dict));
}

std::string EmailTemplateParams::toJsonString() const
{
    json::Builder builder;
    builder << [&] (json::ObjectBuilder b) {
        b["args"] << dict_;
    };
    return builder.str();
}

const std::map<std::string, std::string>&
EmailTemplateParams::data() const
{
    return dict_;
}

EmailTemplateParams&
EmailTemplateParams::addParam(const std::string& name, const std::string& value)
{
    dict_[name] = value;
    return *this;
}

EmailTemplateParams&
EmailTemplateParams::addUrlParam(const std::string& name, const std::string& url)
{
    dict_[name] = eraseSchema(url);
    return *this;
}

std::ostream&
operator<<(std::ostream& out, const EmailTemplateParams& params)
{
    out << (json::Builder() << params.data()).str();
    return out;
}

} // namespace maps::wiki::sender
