#include "json_util.h"

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::sender {

void assertJsonObjectHasFields(
    const json::Value& object,
    const std::vector<std::string>& requiredFields)
{
    ASSERT(object.isObject());
    for (const auto& field : requiredFields) {
        REQUIRE(object.hasField(field), "Field '" << field << "' doesn't exist");
    }
}

} // namespace maps::wiki::sender
