#include <maps/wikimap/mapspro/libs/sender/include/localized_string.h>
#include "json_util.h"

namespace maps::wiki::sender {

NotExistingLangError::NotExistingLangError(const Lang& lang) :
    RuntimeError("Value for language '" + lang + "' doesn't exist")
{}

LocalizedString::LocalizedString(LangToString map) :
    map_(std::move(map))
{}

LocalizedString LocalizedString::fromJson(const json::Value& json)
{
    ASSERT(json.isArray());
    LangToString map;
    for (const auto& entity : json) {
        assertJsonObjectHasFields(entity, {"lang", "value"});
        map.insert({
            {entity["lang"].as<std::string>(), entity["value"].as<std::string>()}
        });
    }
    return LocalizedString(std::move(map));
}

bool LocalizedString::isLangExists(const Lang& lang) const
{
    return map_.count(lang);
}

const std::string& LocalizedString::getForLang(const Lang& lang) const
{
    if (!isLangExists(lang)) {
        throw NotExistingLangError(lang);
    }
    return map_.at(lang);
}

const LangToString& LocalizedString::getAllLangs() const
{
    return map_;
}

} // namespace maps::wiki::sender
