#pragma once

#include "defs.h"
#include "localized_string.h"

#include <maps/libs/common/include/exception.h>
#include <maps/libs/json/include/value.h>

#include <vector>

namespace maps::wiki::sender {

struct SubCampaignAchieveEdits
{
    static SubCampaignAchieveEdits fromJson(const json::Value& json);

    std::string nick;
    std::vector<int> edits;
    LocalizedString slugs;
};

using SubCampaignsAchieveEdits = std::vector<SubCampaignAchieveEdits>;


struct NotExistingCampaignAchieveEditsError : RuntimeError
{
    NotExistingCampaignAchieveEditsError(int edits, const Lang& lang);
};


class CampaignAchieveEdits
{
public:
    CampaignAchieveEdits() = default;
    CampaignAchieveEdits(std::string name, SubCampaignsAchieveEdits subCampaigns);
    static CampaignAchieveEdits fromJson(const json::Value& json);

    const std::string& getName() const;
    const CampaignSlug& getCampaignSlug(int edits, const Lang& lang) const;

private:
    std::string name_;
    SubCampaignsAchieveEdits subCampaigns_;
};

} // namespace maps::wiki::sender
