#pragma once

#include "localized_string.h"
#include "campaign_achieve_edits.h"
#include <maps/libs/json/include/value.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::sender {

struct LocalizedCampaign
{
    static LocalizedCampaign fromJson(const json::Value& json);

    std::string name;
    LocalizedString slugs;
};

struct NotExistingCampaignError : RuntimeError
{
    NotExistingCampaignError(const std::string& campaign);
};


using NameToLocalizedCampaign = std::map<std::string, LocalizedCampaign>;


class CampaignsSlugs
{
public:
    CampaignsSlugs() = default;
    CampaignsSlugs(
        NameToLocalizedCampaign localizedCampaigns,
        CampaignAchieveEdits campaignAchieveEdits);

    static CampaignsSlugs fromJson(const json::Value& json);

    bool isLocalizedExists(const std::string& name) const;
    const LocalizedCampaign& getLocalizedByName(const std::string& name) const;

    const CampaignAchieveEdits& getAchieveEdits() const;

private:
    NameToLocalizedCampaign localizedCampaigns_;
    CampaignAchieveEdits campaignAchieveEdits_;
};

} // namespace maps::wiki::sender
