#pragma once

#include "localized_string.h"
#include "campaigns.h"
#include <maps/libs/json/include/value.h>

namespace maps::wiki::sender {

struct Credentials
{
    static Credentials fromJson(const json::Value& json);

    std::string userId;
    std::string accountSlug;
};


struct ConstantParams
{
    static ConstantParams fromJson(const json::Value& json);

    LocalizedString mapsUrl;
    LocalizedString nmapsUrl;
    LocalizedString feedbackUrl;
    LocalizedString clubUrl;
    LocalizedString unsubscribeUrlTemplate;
};


struct Config
{
    static Config fromJson(const json::Value& json);

    Credentials credentials;
    std::string endPoint;
    CampaignsSlugs campaignSlugs;
    ConstantParams constantParams;
};

Config loadDefaultConfig();

} // namespace maps::wiki::sender
