#pragma once

#include <string>
#include <sstream>
#include <map>

namespace maps::wiki::sender {

class EmailTemplateParams
{
public:
    EmailTemplateParams() = default;
    explicit EmailTemplateParams(std::map<std::string, std::string> dict);

    static EmailTemplateParams fromDict(std::map<std::string, std::string> dict);
    static EmailTemplateParams fromJson(const std::string& json);

    std::string toJsonString() const;

    const std::map<std::string, std::string>& data() const;

    EmailTemplateParams& addParam(const std::string& name, const std::string& value);

    template<class T>
    EmailTemplateParams& addParam(const std::string& name, const T& value)
    {
        std::stringstream stream;
        stream << value;
        addParam(name, stream.str());
        return *this;
    }

    EmailTemplateParams& addUrlParam(const std::string& name, const std::string& url);

private:
    std::map<std::string, std::string> dict_;
};

std::ostream& operator<<(std::ostream& out, const EmailTemplateParams& params);

} // namespace maps::wiki::sender
