#pragma once

#include "defs.h"
#include <maps/libs/json/include/value.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::sender {

struct NotExistingLangError : RuntimeError
{
    NotExistingLangError(const Lang& lang);
};


using LangToString = std::map<Lang, std::string>;


class LocalizedString
{
public:
    LocalizedString() = default;
    LocalizedString(LangToString map);
    static LocalizedString fromJson(const json::Value& json);

    bool isLangExists(const Lang& lang) const;
    const std::string& getForLang(const Lang& lang) const;
    const LangToString& getAllLangs() const;

private:
    LangToString map_;
};

} // namespace maps::wiki::sender
