#include "aoi_feed.h"

#include "magic_strings.h"

#include <string>

namespace maps::wiki::social::impl {

TIds
getAoiIdsOfActiveEditTask(pqxx::transaction_base& txn, TId commitId)
{
    const auto query =
        "SELECT " + sql::col::AOI_ID + "\n"
        "FROM " + sql::table::AOI_FEED_TRUNK_TASK_ACTIVE + "\n"
        "WHERE " + sql::col::EVENT_ID + " IN (\n"
        "  SELECT " + sql::col::EVENT_ID + "\n"
        "  FROM " + sql::table::COMMIT_EVENT + "\n"
        "  WHERE " + sql::col::COMMIT_ID + " = " + std::to_string(commitId) + "\n"
        "    AND " + sql::col::TYPE + " = '" + sql::value::EVENT_TYPE_EDIT + "'\n"
        ")";

    TIds result;
    for (const auto& row: txn.exec(query)) {
        result.emplace(row[0].as<TId>());
    }
    return result;
}

} // namespace maps::wiki::social::impl
