#include <yandex/maps/wiki/social/common.h>

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::social {

constexpr maps::enum_io::Representations<CommentType> COMMENT_TYPE_REPRESENTATION {
    {CommentType::Info,               "info"},
    {CommentType::Complaint,          "complaint"},
    {CommentType::Warn,               "warn"},
    {CommentType::RequestForDeletion, "request-for-deletion"},
    {CommentType::RevertReason,       "revert-reason"},
    {CommentType::Annotation,         "annotation"}
};
DEFINE_ENUM_IO(CommentType, COMMENT_TYPE_REPRESENTATION);

constexpr maps::enum_io::Representations<EventType> EVENT_TYPE_REPRESENTATION {
    {EventType::Edit,               "edit"},
    {EventType::Complaint,          "complaint"},
    {EventType::RequestForDeletion, "request-for-deletion"},
    {EventType::ClosedFeedback,     "closed-feedback"}
};
DEFINE_ENUM_IO(EventType, EVENT_TYPE_REPRESENTATION);

constexpr maps::enum_io::Representations<TasksOrder> TASKS_ORDER_REPRESENTATION {
    {TasksOrder::NewestFirst, "NewestFirst"},
    {TasksOrder::OldestFirst, "OldestFirst"}
};
DEFINE_ENUM_IO(TasksOrder, TASKS_ORDER_REPRESENTATION);

constexpr maps::enum_io::Representations<UserActivityAction> USER_ACTIVITY_ACTION_REPRESENTATION {
    {UserActivityAction::CreateCommit, "create-commit"},
    {UserActivityAction::CreateComment, "create-comment"},
    {UserActivityAction::DeleteComment, "delete-comment"},
    {UserActivityAction::ClearComments, "clear-comments"},
};
DEFINE_ENUM_IO(UserActivityAction, USER_ACTIVITY_ACTION_REPRESENTATION);

} // namespace maps::wiki::social
