#include <yandex/maps/wiki/social/event_alert.h>

#include "magic_strings.h"

namespace maps::wiki::social {

EventAlert::EventAlert(TId eventId, uint32_t priority, std::string description, TId objectId)
    : eventId_(eventId)
    , priority_(priority)
    , description_(std::move(description))
    , objectId_(objectId)
{}

EventAlert::EventAlert(const pqxx::row& row)
    : eventId_(row[sql::col::EVENT_ID].as<TId>())
    , priority_(row[sql::col::PRIORITY].as<uint32_t>())
    , description_(row[sql::col::DESCRIPTION].as<std::string>())
    , objectId_(row[sql::col::OBJECT_ID].as<TId>())
{}

} // namespace maps::wiki::social
