#include <yandex/maps/wiki/social/event_filter.h>

namespace maps::wiki::social {

#define DEFINE_EVENT_FILTER_METHODS(T, name)                    \
    EventFilter& EventFilter::name(T name)                      \
    {                                                           \
        name ## _ = std::move(name);                            \
        return *this;                                           \
    }                                                           \
    const std::optional<T>& EventFilter::name() const noexcept  \
    {                                                           \
        return name ## _;                                       \
    }

DEFINE_EVENT_FILTER_METHODS(TId, aoiId)
DEFINE_EVENT_FILTER_METHODS(TId, createdBy)
DEFINE_EVENT_FILTER_METHODS(TId, resolvedBy)
DEFINE_EVENT_FILTER_METHODS(TId, objectId)
DEFINE_EVENT_FILTER_METHODS(CategoryIdsSet, categoryIds)
DEFINE_EVENT_FILTER_METHODS(EventType, eventType)
DEFINE_EVENT_FILTER_METHODS(bool, commonTasksPermitted)
DEFINE_EVENT_FILTER_METHODS(bool, suspiciousUsers)
DEFINE_EVENT_FILTER_METHODS(bool, noviceUsers)
DEFINE_EVENT_FILTER_METHODS(TIds, commitIds)
DEFINE_EVENT_FILTER_METHODS(ModerationMode, moderationMode)
DEFINE_EVENT_FILTER_METHODS(Deferred, deferred)


EventFilter& EventFilter::areFeedbackTasksPermitted(bool permitted)
{
    areFeedbackTasksPermitted_ = permitted;
    return *this;
}

bool EventFilter::areFeedbackTasksPermitted() const
{
    return areFeedbackTasksPermitted_;
}

} // namespace maps::wiki::social
