#include <yandex/maps/wiki/social/feed_action.h>

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::social {

constexpr maps::enum_io::Representations<FeedAction> FEED_ACTION_REPRESENTATION {
    {FeedAction::GroupModifiedAttributes, "group-modified-attributes"},
    {FeedAction::ObjectModified,          "object-modified"},
    {FeedAction::Service,                 "service"},
    {FeedAction::GroupDeleted,            "group-deleted"},
    {FeedAction::CommitReverted,          "commit-reverted"},
    {FeedAction::ObjectDeleted,           "object-deleted"},
    {FeedAction::GroupModifiedRelation,   "group-modified-relation"},
    {FeedAction::ObjectCreated,           "object-created"},
    {FeedAction::GroupUnited,             "group-united"},
    {FeedAction::GroupMerged,             "group-merged"},
    {FeedAction::Import,                  "import"},
    {FeedAction::GroupMoved,              "group-moved"},
    {FeedAction::GroupSnapped,            "group-snapped"}
};
DEFINE_ENUM_IO(FeedAction, FEED_ACTION_REPRESENTATION);

} // namespace maps::wiki::social