#pragma once
#include "magic_strings.h"

#include <yandex/maps/wiki/common/string_utils.h>
#include <yandex/maps/wiki/social/event.h>
#include <yandex/maps/wiki/social/common.h>

#include <yandex/maps/wiki/social/i_feed.h>

#include <pqxx/pqxx>

namespace maps::wiki::social {

enum class PushOrder { Back, Front };
enum class DataOrder { Asc, Desc };

const size_t AOI_TRUNK_COUNT_LIMIT = 100000;

const std::vector<std::string> COMMIT_EVENT_FIELDS{
    sql::col::EVENT_ID,
    sql::col::TYPE,
    sql::col::CREATED_BY,
    sql::col::CREATED_AT,

    sql::col::BRANCH_ID,
    sql::col::COMMIT_ID,
    sql::col::ACTION,
    sql::col::BOUNDS,

    sql::col::PRIMARY_OBJECT_ID,
    sql::col::PRIMARY_OBJECT_CATEGORY_ID,
    sql::col::PRIMARY_OBJECT_LABEL,
    sql::col::PRIMARY_OBJECT_NOTES,
};

const std::string COMMIT_EVENTS_ALIAS = "ce";

const std::string COMMIT_EVENT_FIELDS_TO_SELECT =
    maps::wiki::common::join(
        maps::wiki::social::COMMIT_EVENT_FIELDS.begin(),
        maps::wiki::social::COMMIT_EVENT_FIELDS.end(),
        [](const std::string& column) { return COMMIT_EVENTS_ALIAS + "." + column; },
        ',');

const std::string SELECT_COMMIT_EVENT_FIELDS =
    "SELECT " +
    COMMIT_EVENT_FIELDS_TO_SELECT +
    " FROM " + sql::table::COMMIT_EVENT + " " + COMMIT_EVENTS_ALIAS;

std::pair<Events, HasMore>
createEvents(
    const pqxx::result& r,
    std::optional<size_t> limit,
    PushOrder order
);

std::string
categoryIds2str(
    pqxx::transaction_base& work,
    const CategoryIdsSet& categoryIds
);

std::string
categoriesWhereCondition(
    pqxx::transaction_base& work,
    const CategoryIdsFilter& categoryIdsFilter
);

} // namespace maps::wiki::social
