#include <yandex/maps/wiki/social/feedback/converter_checks.h>
#include <yandex/maps/wiki/social/feedback/description_keys.h>

#include <map>
#include <set>

namespace maps::wiki::social::feedback {

namespace {

const std::map<std::string, Type> TASK_TYPE_FROM_CHECK_ID {
    {"addr_uniqueness", Type::Address},
    {"poi_naming", Type::Poi},
    {"addr_geometry", Type::Address},
    {"rd_ad_uniqueness", Type::Other},
    {"urban_roadnet_parking", Type::Parking},
    {"addr_naming", Type::Address},
    {"dead_ends", Type::Road},
    {"rd_ad_inclusion", Type::Road},
    {"rd_ad_relations", Type::Road},
    {"poi_conflicts", Type::Poi},
    {"poi_position_quality", Type::Poi},
    {"poi_entrance_naming", Type::Entrance},
};

const std::set<std::string> AVAILABLE_VALIDATION_DESCRIPTIONS {
    "unnamed-poi",
    "illegal-letter-for-name-lang",
    "non-local-name-for-local-lang",
    "official-name-missing",
    "max-name-length-exceeded",
    "name-with-all-capital-letters",
    "multiple-non-synonym-names",
    "double-space-in-name",
    "name-begins-with-space",
    "illegal-symbol-in-poi-name",
    "visit-internal-error",
    "unknown-name-lang",
    "parking-territory-is-not-connected-to-parking-lot",
    "addr-outside-building",
    "addr-too-far-from-road",
    "addr-outside-adm-unit",
    "illegal-letter-in-addr-name",
    "dual-carriageway-dead-end",
    "duplicate-address-point-names",
    "ad-duplicate-road-names",
    "dead-end",
    "no-continuation-high-fc",
    "rd-not-within-ad-geom",
    "poi-visibility-conflict",
    "poi-not-verified",
    "max-entrance-name-length-exceeded",
};

const std::set<std::string> AVAILABLE_VALIDATION_DESCRIPTIONS_ROAD_WITHOUT_GEOMETRY {
    "unbound-named-road"
};

} // namespace

std::optional<std::string>
tankerKeyFromValidationDescription(
    const std::string& description)
{
    if (AVAILABLE_VALIDATION_DESCRIPTIONS.count(description)) {
        return tanker::fb_desc::FB_KEYSET + "validator-message-" + description;
    }
    return std::nullopt;
}

std::optional<std::string>
tankerKeyFromValidationDescriptionRoadWithoutGeometry(
    const std::string& description)
{
    if (AVAILABLE_VALIDATION_DESCRIPTIONS_ROAD_WITHOUT_GEOMETRY.count(description)) {
        return tanker::fb_desc::FB_KEYSET + "validator-message-" + description;
    }
    return std::nullopt;
}

std::vector<std::string> validationFeedbackConverterDescriptions()
{
    std::vector<std::string> descriptions;
    for (const auto& descr : AVAILABLE_VALIDATION_DESCRIPTIONS) {
        descriptions.push_back(descr);
    }
    for (const auto& descr : AVAILABLE_VALIDATION_DESCRIPTIONS_ROAD_WITHOUT_GEOMETRY) {
        descriptions.push_back(descr);
    }
    return descriptions;
}

std::vector<std::string> validationFeedbackConverterChecks()
{
    std::vector<std::string> checks;
    for (const auto& [check, _] : TASK_TYPE_FROM_CHECK_ID) {
        checks.push_back(check);
    }
    return checks;
}

std::optional<Type> taskTypeFromValidationCheckId(const std::string& checkId)
{
    if (TASK_TYPE_FROM_CHECK_ID.count(checkId)) {
        return TASK_TYPE_FROM_CHECK_ID.at(checkId);
    }
    return std::nullopt;
}

} // namespace maps::wiki::social::feedback
