#include <yandex/maps/wiki/social/feedback/description.h>
#include <maps/libs/common/include/exception.h>


namespace maps::wiki::social::feedback {

DescriptionI18n::DescriptionI18n(
    std::string i18nKey, ParamToDescription i18nParams)
:
    i18nKey_(std::move(i18nKey)), i18nParams_(std::move(i18nParams))
{
}

const std::string& DescriptionI18n::i18nKey() const
{
    return i18nKey_;
}

const ParamToDescription& DescriptionI18n::i18nParams() const
{
    return i18nParams_;
}

bool DescriptionI18n::operator == (const DescriptionI18n& other) const
{
    return i18nKey_ == other.i18nKey_ && i18nParams_ == other.i18nParams_;
}

Description::Description() :
    repr_("")
{}

Description::Description(std::string nonTranslatable) :
    repr_(std::move(nonTranslatable))
{}

Description::Description(DescriptionI18n translatable) :
    repr_(std::move(translatable))
{}

bool Description::isNonTranslatable() const
{
    return std::holds_alternative<std::string>(repr_);
}

bool Description::isTranslatable() const
{
    return std::holds_alternative<DescriptionI18n>(repr_);
}

const std::string& Description::asNonTranslatable() const
{
    ASSERT(isNonTranslatable());
    return std::get<std::string>(repr_);
}

const DescriptionI18n& Description::asTranslatable() const
{
    ASSERT(isTranslatable());
    return std::get<DescriptionI18n>(repr_);
}

bool Description::operator == (const Description& other) const
{
    return repr_ == other.repr_;
}

} // namespace maps::wiki::social::feedback
