#include <yandex/maps/wiki/social/feedback/history.h>
#include <maps/libs/enum_io/include/enum_io.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/json/include/value.h>

#include <algorithm>

namespace maps::wiki::social::feedback {

namespace {

constexpr enum_io::Representations<TaskOperation>
    TASK_OPERATION_STRINGS{
    {TaskOperation::Create,              "create"},
    {TaskOperation::Defer,               "defer"},
    {TaskOperation::Reveal,              "reveal"},
    {TaskOperation::Open,                "open"},
    {TaskOperation::NeedInfo,            "need-info"},
    {TaskOperation::Acquire,             "acquire"},
    {TaskOperation::Release,             "release"},
    {TaskOperation::Accept,              "accept"},
    {TaskOperation::Reject,              "reject"},
    {TaskOperation::Deploy,              "deploy"},
    {TaskOperation::Comment,             "comment"},
    {TaskOperation::Hide,                "hide"},
    {TaskOperation::Show,                "show"},
    {TaskOperation::ChangeType,          "change-type"},
    {TaskOperation::ChangePosition,      "change-position"},
    {TaskOperation::MarkViewed,          "mark-viewed"},
    {TaskOperation::ProcessingLevelUp,   "processing-level-up"},
    {TaskOperation::ProcessingLevelDown, "processing-level-down"},
    {TaskOperation::ChangeProcessingLvl, "change-processing-lvl"},
    {TaskOperation::Unrecognized,        "unrecognized"},
};

} // unnamed namespace

DEFINE_ENUM_IO(TaskOperation, TASK_OPERATION_STRINGS);

History::History(HistoryItems orderedItems)
    : items_(std::move(orderedItems))
{
    TId itemId = 0;
    for (auto& item : items_) {
        item.setId(itemId);
        ++itemId;
    }
}

const HistoryItems& History::items() const
{
    return items_;
}

std::optional<HistoryItem> History::lastItemWith(TaskOperation operation) const {
    auto rIter = std::find_if(
        std::rbegin(items_),
        std::rend(items_),
        [&](const HistoryItem& item) {
            return item.operation() == operation;
        }
    );

    if (rIter == std::rend(items_)) {
        return std::nullopt;
    }

    return *rIter;
}

} // namespace maps::wiki::social::feedback
