#include <maps/libs/enum_io/include/enum_io.h>
#include <yandex/maps/wiki/social/feedback/mv_source_type.h>
#include <yandex/maps/wiki/common/string_utils.h>
#include <yandex/maps/wiki/common/pg_utils.h>

#include <maps/wikimap/mapspro/libs/social/feedback/util.h>
#include <maps/wikimap/mapspro/libs/social/feedback/workflow_logic.h>
#include <maps/wikimap/mapspro/libs/social/helpers.h>
#include <maps/wikimap/mapspro/libs/social/magic_strings.h>

namespace maps::wiki::social::feedback {

namespace {

std::string ageTypesFilterExpr(const AgeTypes& ageTypes)
{
    if (ageTypes.empty()) {
        return "FALSE";
    }

    return putInBrackets(
        common::join(ageTypes, ageTypeMatViewSqlCondition, "OR")
    );
}

} // namespace anonymous

std::string MvSourceTypeFilter::whereClause() const
{
    std::stringstream query;

    query << "TRUE";

    if (status_) {
        query << " AND " << sql::col::STATUS << " = '" << *status_ << "'";
    }
    if (hidden_) {
        query << " AND " << sql::col::HIDDEN << " = " << toPgValue(*hidden_);
    }
    if (sources_) {
        query << " AND " << sql::col::SOURCE << " "
              << common::sqlInCondition(*sources_);
    }
    if (types_) {
        query << " AND " << sql::col::TYPE << " "
              << common::sqlInCondition(*types_);
    }
    if (ageTypes_) {
        query << " AND " << ageTypesFilterExpr(*ageTypes_);
    }
    if (workflows_) {
        query << " AND " << feedback::whereClause(*workflows_);
    }
    if (!baseDimensionsArray_.empty()) {
        query << internal::BaseDimensionsArrayWhereClause(baseDimensionsArray_);
    }

    return query.str();
}

MvSourceTypeFilter& MvSourceTypeFilter::status(std::optional<UIFilterStatus> status)
{
    status_ = status;
    return *this;
}

MvSourceTypeFilter& MvSourceTypeFilter::hidden(std::optional<bool> hidden)
{
    hidden_ = hidden;
    return *this;
}

MvSourceTypeFilter& MvSourceTypeFilter::sources(std::optional<std::vector<std::string>> sources)
{
    sources_ = std::move(sources);
    return *this;
}

MvSourceTypeFilter& MvSourceTypeFilter::types(std::optional<Types> types)
{
    types_ = std::move(types);
    return *this;
}

MvSourceTypeFilter& MvSourceTypeFilter::ageTypes(std::optional<AgeTypes> ageTypes)
{
    ageTypes_ = std::move(ageTypes);
    return *this;
}

MvSourceTypeFilter& MvSourceTypeFilter::workflows(std::optional<Workflows> workflows)
{
    workflows_ = std::move(workflows);
    return *this;
}

MvSourceTypeFilter& MvSourceTypeFilter::addBaseDimensions(BaseDimensions baseDimensions)
{
    baseDimensionsArray_.emplace_back(std::move(baseDimensions));
    return *this;
}

std::set<std::string>
mvSourcesByFilter(
    pqxx::transaction_base& socialTxn,
    const MvSourceTypeFilter& filter)
{
    std::stringstream query;

    query << " SELECT DISTINCT " << sql::col::SOURCE
          << " FROM " << sql::table::FEEDBACK_DISTINCT_SOURCE_TYPE_MV
          << " WHERE " << filter.whereClause();

    std::set<std::string> sources;
    for (const auto& row : socialTxn.exec(query.str())) {
        sources.insert(row[0].as<std::string>());
    }
    return sources;
}

Types
mvTypesByFilter(
    pqxx::transaction_base& socialTxn,
    const MvSourceTypeFilter& filter)
{
    std::stringstream query;

    query << " SELECT DISTINCT " << sql::col::TYPE
          << " FROM " << sql::table::FEEDBACK_DISTINCT_SOURCE_TYPE_MV
          << " WHERE " << filter.whereClause();

    Types types;
    for (const auto& row : socialTxn.exec(query.str())) {
        types.push_back(
            boost::lexical_cast<Type>(row[0].as<std::string>())
        );
    }
    return types;
}

void refreshSourceTypeMv(pqxx::transaction_base& socialTxn)
{
    socialTxn.exec(
        "REFRESH MATERIALIZED VIEW CONCURRENTLY " +
        sql::table::FEEDBACK_DISTINCT_SOURCE_TYPE_MV
    );
}

} // namespace maps::wiki::social::feedback
