#include <yandex/maps/wiki/social/feedback/partition.h>
#include <maps/wikimap/mapspro/libs/social/magic_strings.h>

namespace maps::wiki::social::feedback {

namespace {

const std::vector<Partition> ALL_PARTITIONS {
    Partition::Pending,
    Partition::OutgoingOpened,
    Partition::OutgoingOpenedExperiment,
    Partition::OutgoingClosed
};

} // unnamed namespace

const std::vector<Partition>& allPartitions()
{
    return ALL_PARTITIONS;
}

std::string feedbackPartitionTable(Partition partition)
{
    switch (partition) {
        case Partition::Pending:
            return sql::table::FEEDBACK_TASK_PENDING;
        case Partition::OutgoingOpened:
            return sql::table::FEEDBACK_TASK_OUTGOING_OPENED;
        case Partition::OutgoingOpenedExperiment:
            return sql::table::FEEDBACK_TASK_OUTGOING_OPENED_EXPERIMENT;
        case Partition::OutgoingClosed:
            return sql::table::FEEDBACK_TASK_OUTGOING_CLOSED;
    }
}

std::string aoiFeedbackFeedPartitionTable(Partition partition)
{
    switch (partition) {
        case Partition::Pending:
            return sql::table::FEEDBACK_AOI_FEED_PENDING;
        case Partition::OutgoingOpened:
            return sql::table::FEEDBACK_AOI_FEED_OUTGOING_OPENED;
        case Partition::OutgoingOpenedExperiment:
            return sql::table::FEEDBACK_AOI_FEED_OUTGOING_OPENED_EXPERIMENT;
        case Partition::OutgoingClosed:
            return sql::table::FEEDBACK_AOI_FEED_OUTGOING_CLOSED;
    }
}

Partition getPartition(const Task& task)
{
    if (task.bucket() == Bucket::Incoming || task.bucket() == Bucket::Deferred) {
        return Partition::Pending;
    }
    if (task.resolved()) {
        return Partition::OutgoingClosed;
    }
    return Partition::OutgoingOpened;
}

} // namespace maps::wiki::social::feedback
