#include <yandex/maps/wiki/social/feedback/review.h>

namespace maps::wiki::social::feedback {

constexpr enum_io::Representations<ReviewState>
REVIEW_STATE_STRINGS {
    {ReviewState::Draft, "draft"},
    {ReviewState::Published, "published"},
};
DEFINE_ENUM_IO(ReviewState, REVIEW_STATE_STRINGS);

constexpr enum_io::Representations<ReviewTaskComment::Topic>
REVIEW_TASK_COMMENT_TOPIC_STRINGS {
    {ReviewTaskComment::Topic::BadPhoto, "bad-photo"},
    {ReviewTaskComment::Topic::MissingObjects, "missing-objects"},
    {ReviewTaskComment::Topic::Other, "other"},
    {ReviewTaskComment::Topic::UnwantedObjects, "unwanted-objects"},
};
DEFINE_ENUM_IO(ReviewTaskComment::Topic, REVIEW_TASK_COMMENT_TOPIC_STRINGS);

ReviewBrief::ReviewBrief(
        TId id,
        ReviewState state,
        TUid createdBy,
        TUid reviewee,
        TId regionId,
        TId regionCommitId)
    : id_(id)
    , state_(state)
    , createdAt_(chrono::TimePoint::clock::now())
    , createdBy_(createdBy)
    , reviewee_(reviewee)
    , regionId_(regionId)
    , regionCommitId_(regionCommitId)
{
}

ReviewBrief::ReviewBrief(const pqxx::row& row)
    : id_(row["review_id"].as<TId>())
    , state_(row["published_at"].is_null()
        ? ReviewState::Draft
        : ReviewState::Published)
    , createdAt_(chrono::parseSqlDateTime(row["created_at"].c_str()))
    , createdBy_(row["created_by"].as<TUid>())
    , publishedAt_(row["published_at"].is_null()
        ? std::optional<chrono::TimePoint>()
        : chrono::parseSqlDateTime(row["published_at"].c_str()))
    , reviewee_(row["reviewee"].as<TUid>())
    , regionId_(row["region_id"].as<TId>())
    , regionCommitId_(row["region_commit_id"].as<TId>())
    , reportData_(row["report_data"].is_null() ? std::string() : row["report_data"].c_str())
    , comment_(row["review_comment"].is_null() ? std::string() : row["review_comment"].c_str())
{
}

void
Review::setPublished(const std::string& reportData)
{
    ASSERT(state_ == ReviewState::Draft);
    state_ = ReviewState::Published;
    reportData_ = reportData;
}

void
Review::setComment(const std::string& comment)
{
    comment_ = comment;
}

void
Review::setTaskComment(TId taskId, const std::string& comment, std::optional<ReviewTaskComment::Topic> topic)
{
    if (!comment.empty() && !topic) {
        throw InvalidReviewOperation() <<
            "Review comment should have topic";
    }
    tasksComments_[taskId] = {
            topic,
            comment
    };
}

}// namespace maps::wiki::social::feedback
