#include <maps/wikimap/mapspro/libs/social/feedback/stats.h>

#include <maps/wikimap/mapspro/libs/social/helpers.h>

#include <maps/libs/stringutils/include/join.h>
#include <maps/libs/stringutils/include/to_string.h>

#include <fmt/format.h>


namespace maps::wiki::social::feedback::stats {

using namespace fmt::literals;
using stringutils::join;
using stringutils::toStrings;

size_t
countOperationsToday(
    pqxx::transaction_base& txn,
    const TaskOperations &operations,
    TUid uid,
    int tzOffsetInMinutes)
{
    const auto operationsStr = "'" + join(toStrings(operations), "','") + "'";

    const auto query = fmt::format(
        "SELECT COUNT(1)\n"
        "FROM {feedback_history}\n"
        "WHERE\n"
        "  {modified_by} = {uid} AND\n"
        "  {modified_at} >= {midnight} AND\n"
        "  {operation} IN ({operations})",

        "feedback_history"_a = sql::table::FEEDBACK_HISTORY,
        "modified_by"_a = sql::col::MODIFIED_BY,
        "uid"_a = uid,
        "modified_at"_a = sql::col::MODIFIED_AT,
        "midnight"_a = userMidnightExpression(tzOffsetInMinutes),
        "operation"_a = sql::col::OPERATION,
        "operations"_a = operationsStr
    );

    return txn.exec(query)[0][0].as<size_t>();
}

} // maps::wiki::social::feedback::stats
