#include <yandex/maps/wiki/social/feedback/task_patch.h>

namespace maps::wiki::social::feedback {

TaskPatch& TaskPatch::setAcquired()
{
    isAcquired_ = true;
    return *this;
}

TaskPatch& TaskPatch::setReleased()
{
    isAcquired_ = false;
    return *this;
}

TaskPatch& TaskPatch::setAcquired(const chrono::TimePoint& date)
{
    setAcquired();
    acquiredAt_ = date;
    return *this;
}

TaskPatch& TaskPatch::setResolution(
    std::optional<Resolution> resolution)
{
    resolution_ = std::move(resolution);
    return *this;
}

TaskPatch& TaskPatch::setDeployedAt(chrono::TimePoint value)
{
    deployedAt_ = value;
    return *this;
}

TaskPatch& TaskPatch::setHidden(bool value)
{
    hidden_ = value;
    return *this;
}

TaskPatch& TaskPatch::setBucket(Bucket value)
{
    bucket_ = value;
    return *this;
}

TaskPatch& TaskPatch::setNeedInfo(std::optional<std::string> requestTemplate)
{
    setBucket(Bucket::NeedInfo);
    needInfoRequestTemplate_ = std::move(requestTemplate);
    return *this;
}

TaskPatch& TaskPatch::setDuplicateHeadId(std::optional<TId> headId)
{
    duplicateHeadId_ = headId;
    return *this;
}

TaskPatch& TaskPatch::setViewedByUpdater()
{
    viewedByUpdater_ = true;
    return *this;
}

TaskPatch& TaskPatch::setCommentId(TId value)
{
    REQUIRE(!commentId_, "Comment lost.");
    commentId_ = value;
    return *this;
}

TaskPatch& TaskPatch::setType(Type value)
{
    type_ = value;
    return *this;
}

TaskPatch& TaskPatch::setProcessingLvl(ProcessingLvl value, std::optional<Verdict> suggestedVerdict)
{
    if (suggestedVerdict) {
        suggestedVerdict_ = suggestedVerdict;
    }
    processingLvl_ = value;
    return *this;
}

TaskPatch& TaskPatch::setPosition(geolib3::Point2 point)
{
    position_ = std::move(point);
    return *this;
}

} // namespace maps::wiki::social::feedback
