#include <yandex/maps/wiki/social/feedback/attribute_names.h>
#include <yandex/maps/wiki/social/feedback/task_specific_attrs.h>
#include <yandex/maps/wiki/social/feedback/task.h>

#include "task_consistency.h"

#include <boost/lexical_cast.hpp>

namespace maps::wiki::social::feedback {

bool operator == (const SpeedLimitAttrs& lhs, const SpeedLimitAttrs& rhs)
{
    return lhs.currentSpeedLimit == rhs.currentSpeedLimit &&
        lhs.correctSpeedLimit == rhs.correctSpeedLimit;
}

SpeedLimitAttrs extractSpeedLimitAttrs(const Task& task)
{
    requireSpeedLimitConsistency(task);
    const auto& attrs = task.attrs();

    std::optional<int> currentSpeedLimit;
    if (attrs.existCustom(attrs::CURRENT_SPEED_LIMIT)) {
        currentSpeedLimit = boost::lexical_cast<int>(
            attrs.getCustom(attrs::CURRENT_SPEED_LIMIT));
    }

    int correctSpeedLimit = boost::lexical_cast<int>(
        attrs.getCustom(attrs::CORRECT_SPEED_LIMIT));

    return {currentSpeedLimit, correctSpeedLimit};
}

} // namespace maps::wiki::social::feedback
