#include <yandex/maps/wiki/social/feedback/twins.h>
#include <yandex/maps/wiki/social/feedback/gateway_rw.h>

namespace maps::wiki::social::feedback {

namespace {

const double EPS_DISTANCE = 0.0001;

} // namespace anonymous

std::optional<Task> addTaskIfNotTwin(
    GatewayRW& gatewayRw,
    TUid uid,
    const TaskNew& newTask,
    std::function<bool(const TaskNew& newTask, const Task& task)> isEqual)
{
    // does not check all tasks of database, but only subset
    const auto oldTasks = gatewayRw.tasksByFilter(
        TaskFilter()
            .type(newTask.type)
            .source(newTask.source)
            .boxBoundary({newTask.position, EPS_DISTANCE, EPS_DISTANCE}));

    for (const auto& oldTask : oldTasks) {
        if (isEqual(newTask, oldTask)) {
            return std::nullopt;
        }
    }
    return gatewayRw.addTask(uid, newTask);
}

} // namespace maps::wiki::social::feedback
