#include <yandex/maps/wiki/social/feedback/types_back_compatibility.h>
#include <yandex/maps/wiki/social/feedback/attribute_names.h>
#include <yandex/maps/wiki/social/feedback/description_keys.h>
#include <yandex/maps/wiki/social/feedback/description_producers.h>
#include <maps/libs/common/include/exception.h>
#include <boost/algorithm/string.hpp>

namespace maps::wiki::social::feedback::back_compat {

const std::string ABSENT_BARRIER_DESCR =
    "На карте отсутствует шлагбаум";

const std::string ABSENT_ENTRANCE_DESCR =
    "На карте отсутствует подъезд номер";

bool isAbsentBarrierDescr(const std::string& descr)
{
    return boost::algorithm::starts_with(descr, ABSENT_BARRIER_DESCR);
}

bool isAbsentEntranceDescr(const std::string& descr)
{
    return boost::algorithm::starts_with(descr, ABSENT_ENTRANCE_DESCR);
}

std::optional<std::string> extractEntranceName(const std::string& descr)
{
    if (!isAbsentEntranceDescr(descr)) {
        return std::nullopt;
    }

    auto start = descr.find_first_not_of(' ', ABSENT_ENTRANCE_DESCR.size());
    if (start == std::string::npos) {
        return std::nullopt;
    }
    return descr.substr(start);
}

std::optional<Type> typeFromDescr(const std::string& descr)
{
    if (isAbsentBarrierDescr(descr)) {
        return Type::Barrier;
    }
    if (isAbsentEntranceDescr(descr)) {
        return Type::Entrance;
    }
    return std::nullopt;
}

Description deduceFbDescr(const std::string& descrStr)
{
    if (isAbsentBarrierDescr(descrStr)) {
        return DescriptionI18n(tanker::fb_desc::ABSENT_BARRIER_KEY);
    }

    if (isAbsentEntranceDescr(descrStr)) {
        return AbsentEntranceDescr{
            extractEntranceName(descrStr)
        }.toDescription();
    }

    throw RuntimeError() << "Unable to deduce Description from " << descrStr;
}

} // namespace maps::wiki::social::feedback::back_compat
