#pragma once

#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/task_feed.h>
#include <maps/wikimap/mapspro/libs/social/magic_strings.h>
#include <yandex/maps/wiki/social/feedback/aggregated_counter.h>
#include <yandex/maps/wiki/social/feedback/enums.h>
#include <yandex/maps/wiki/social/feedback/task.h>

#include <yandex/maps/wiki/common/string_utils.h>

#include <pqxx/pqxx>
#include <set>

namespace maps::wiki::social::feedback {

extern const std::string FIELDS_TO_SELECT;

class HistoryPatch;

template<typename T>
std::vector<T> execTaskQuery(
    pqxx::transaction_base& socialTxn,
    const std::string& query)
{
    std::vector<T> tasks;
    for (const auto& row : socialTxn.exec(query)) {
        tasks.emplace_back(T(row));
    }
    return tasks;
}

inline pqxx::field rowField(
    const pqxx::row& row,
    const std::string& columnName,
    const std::string& tablePrefix)
{
    return row[tablePrefix + columnName];
}

void execUpdateTasks(
    pqxx::transaction_base& socialTxn,
    const std::string& setClause,
    const std::string& whereClause);

std::string putInBrackets(const std::string& str);

std::string ageTypeSqlCondition(AgeType ageType);

std::string ageTypeMatViewSqlCondition(AgeType ageType);

AggregatedCounter rowToAggregatedCounter(const pqxx::row& row);

std::string getAggregatedCountQuery(
    const std::string& whereClause,
    const Columns& groupByFields);

TasksBriefResult
constructTasksBriefResult(TasksBrief&& tasksFromQuery, std::optional<size_t> limit);

} // namespace maps::wiki::social::feedback
