#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/pg_utils.h>
#include <maps/wikimap/mapspro/libs/social/feedback/workflow_logic.h>
#include <maps/wikimap/mapspro/libs/social/magic_strings.h>

#include <set>

namespace maps::wiki::social::feedback {

namespace {

const std::set<std::string> FEEDBACK_SOURCES = {
    "fbapi",
    "fbapi-nologin",
    "fbapi-samsara",
    "nmaps-complaint",
    "nmaps-request-for-deletion",
};

Workflow workflow(const std::string& source)
{
    if (FEEDBACK_SOURCES.contains(source)) {
        return Workflow::Feedback;
    }
    return Workflow::Task;
}

}  // namespace

Workflow workflow(const TaskBrief& task)
{
    return workflow(task.source());
}

Workflow workflow(const TaskNew& task)
{
    return workflow(task.source);
}

std::string whereClause(const Workflows& workflows)
{
    if (workflows.empty()) {
        return "FALSE";
    }

    std::set<Workflow> wSet;
    for (auto workflow : workflows){
        wSet.insert(workflow);
    }

    if (wSet.size() > 1) {
        return "TRUE";
    }

    return whereClause(*wSet.begin());
}

std::string whereClause(Workflow workflow)
{
    std::stringstream clause;
    clause << sql::col::SOURCE << " ";
    switch (workflow) {
        case Workflow::Feedback:
            // no code
            break;
        case Workflow::Task:
            clause << "NOT ";
            break;
    }
    clause << common::sqlInCondition(FEEDBACK_SOURCES);
    return clause.str();
}

std::string workflowFieldClause()
{
    std::stringstream clause;
    clause << "CASE\n"
        << " WHEN " << whereClause(Workflow::Feedback)
        << "    THEN 'feedback'\n"
        << "    ELSE 'task'\n"
        << "END";
    return clause.str();
}

} // namespace maps::wiki::social::feedback
