#pragma once

#include <pqxx/pqxx>
#include <yandex/maps/wiki/social/common.h>
#include <maps/libs/geolib/include/serialization.h>
#include "magic_strings.h"

namespace maps::wiki::social {

void checkUid(TUid uid);
void checkAoi(TId aoiId);
void checkAoi(const TIds& aoiIds);
void checkLimit(size_t limit);
void checkExpires(const std::string& expires);

/**
 * Works properly only when result has no spaces and commas within the items
 * i. e. doesn't support SQL array escaping properly
 */
std::set<std::string> parseStringSetFromSqlArray(const std::string& data);

/**
 * Reversed version of the above method. Same conditions apply
 * Won't append additional quotes, an external pqxx::quote() is required
 */
std::string dumpToSqlArray(const std::set<std::string>& strings);
std::string dumpIdsToSqlArray(const TIds& ids);
std::string unnestArray(pqxx::transaction_base& txn, const TIds& ids);

std::string joinCommentFields();
std::string joinCommentTable(const std::string& parentTableAlias);

/**
 *  Result example:
 *  ('1', 'name1'), ('2', 'name2'), ('3', 'name3')
 */
std::string multirowValuesInsertStatement(
    const std::vector<std::vector<std::string>>& values);

std::string toPgValue(bool b);

template<class Geometry>
std::string makePqxxGeomExpr(
    pqxx::transaction_base& txn,
    const Geometry& geometry)
{
    auto wkb = geolib3::WKB::toString(geometry);
    std::stringstream result;
    result << sql::func::ST_GEOMFROMWKB << "("
            << "'" << txn.esc_raw(wkb) << "', " << sql::value::MERCATOR_SRID
            << ")";
    return result.str();
}

std::string sqlIntervalInSeconds(std::chrono::seconds interval);

std::string userMidnightExpression(int tzOffsetInMinutes);

} // namespace maps::wiki::social
