#pragma once

#include <yandex/maps/wiki/social/common.h>

#include <pqxx/pqxx>

#include <memory>
#include <optional>
#include <vector>

namespace maps::wiki::social {

class Factory;

class Comment
{
public:
    enum class Internal { No, Yes };

    TId id() const { return id_; }
    CommentType type() const { return type_; }

    TId objectId() const { return objectId_; }
    std::optional<TId> feedbackTaskId() const { return feedbackTaskId_; }
    TId commitId() const { return commitId_; }

    TUid createdBy() const { return createdBy_; }
    const std::string& createdAt() const { return createdAt_; }

    TUid deletedBy() const { return deletedBy_; }
    const std::string& deletedAt() const { return deletedAt_; }

    Internal internal() const { return internal_; }

    const std::string& data() const { return data_; }

    bool deleteBy(pqxx::transaction_base& work, TUid uid);
    bool read(pqxx::transaction_base& work);

private:
    friend class Factory;

    explicit Comment(const pqxx::row& row, const std::string& columnPrefix = "");

    static Comment create(
        pqxx::transaction_base& txn,
        TUid uid, CommentType type, const std::string& data,
        TId commitId, TId objectId, std::optional<TId> feedbackTaskId, TId eventId,
        Comment::Internal internal);

    static std::optional<Comment> loadFromJoined(const pqxx::row& row);

    TId id_;
    CommentType type_;
    TId objectId_;
    std::optional<TId> feedbackTaskId_;
    TId commitId_;
    TUid createdBy_;
    std::string createdAt_;
    TUid deletedBy_;
    std::string deletedAt_;
    Comment::Internal internal_;
    std::string data_;
};

using Comments = std::vector<Comment>;

} // namespace maps::wiki::social
