#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <maps/wikimap/mapspro/libs/types/include/uid.h>

#include <chrono>
#include <cstdint>
#include <map>
#include <set>
#include <string>

namespace maps::wiki::social {

using TId = uint64_t;
using types::TUid;

using ExternalReferenceId = std::string;

using UserActivity = std::map<std::chrono::seconds, size_t>;

using FtTypeId = uint16_t;
using BusinessRubricId = uint64_t;

using TIds = std::set<TId>;
using TUids = std::set<TUid>;

using CategoryIdsSet = std::set<std::string>;

enum class ActivityType { Edits, Comments, FeedbackResolve };

enum class CommentType {
    Info,
    Complaint,
    Warn,
    RequestForDeletion,
    RevertReason,
    Annotation
};

DECLARE_ENUM_IO(CommentType);

enum class EventType { Edit, Complaint, RequestForDeletion, ClosedFeedback };
DECLARE_ENUM_IO(EventType);

enum class TasksOrder { NewestFirst, OldestFirst };
DECLARE_ENUM_IO(TasksOrder);

enum class HasMore : bool { Yes = true, No = false};;

enum class Deferred : bool { Yes = true, No = false };

enum class InclusionPolicy { Including, Excluding };

struct CategoryIdsFilter {
    CategoryIdsSet ids;
    InclusionPolicy policy;
};

enum class UserActivityAction {
    CreateCommit,
    CreateComment,
    DeleteComment,
    ClearComments,
};
DECLARE_ENUM_IO(UserActivityAction);

} // namespace maps::wiki::social
