#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <pqxx/pqxx>

namespace maps::wiki::social {

class DateTimeCondition
{
public:
    DateTimeCondition(std::optional<chrono::TimePoint> first, std::optional<chrono::TimePoint> last);

    const std::optional<chrono::TimePoint>& first() const { return first_; }
    const std::optional<chrono::TimePoint>& last() const { return last_; }

    std::string sqlComparison(pqxx::transaction_base& txn, const std::string& expr) const;

    static std::optional<DateTimeCondition>
    makeOptional(std::optional<chrono::TimePoint> first, std::optional<chrono::TimePoint> last);

private:
    static std::string sqlCompareOp(
        pqxx::transaction_base& txn,
        const std::string& expr,
        chrono::TimePoint dateTime,
        const std::string& op);

    std::optional<chrono::TimePoint> first_;
    std::optional<chrono::TimePoint> last_;
};

} // namespace maps::wiki::social
