#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

namespace maps::wiki::social {

struct TotalEditsStat
{
    TUid uid{};

    size_t totalEdits{};
    size_t totalEditsV2{};

    std::optional<int> oldRatingPosCreated;
    std::optional<int> oldRatingPosEdits;

    // TODO:
    // All these values are actually not null in DB.
    // Add corresponding NOT NULL constraint and remove optional here
    //
    std::optional<size_t> edits1dAgoV2;
    std::optional<size_t> edits7dAgoV2;
    std::optional<size_t> edits30dAgoV2;
    std::optional<size_t> edits90dAgoV2;

    std::optional<chrono::TimePoint> firstCommitAt;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(
            t.uid, t.totalEdits, t.totalEditsV2, t.oldRatingPosCreated, t.oldRatingPosEdits,
            t.edits1dAgoV2, t.edits7dAgoV2, t.edits30dAgoV2, t.edits90dAgoV2,
            t.firstCommitAt
        );
    }
};

struct CatGroupEditsStat
{
    TId id{};
    TUid uid{};
    std::string categoryGroup{};
    size_t totalCount{};
    size_t createdCount{};

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.id, t.uid, t.categoryGroup, t.totalCount, t.createdCount);
    }
};

} // namespace maps::wiki::social
