#pragma once

#include "edits_stat.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::wiki::social {

namespace table {
using namespace sql_chemistry;

struct TotalEditsStatTbl : Table<TotalEditsStat>
{
    static constexpr std::string_view name_{"social.stats"};

    static constexpr Int64PrimaryKey uid{"uid"sv, name_};
    static constexpr Int64Column totalEdits{"total_edits"sv, name_};
    static constexpr Int64Column totalEditsV2{"total_edits_v2"sv, name_};
    static constexpr NullableNumericColumn<int> oldRatingPosCreated{"old_rating_pos_created"sv, name_};
    static constexpr NullableNumericColumn<int> oldRatingPosEdits{"old_rating_pos_edits"sv, name_};
    static constexpr NullableInt64Column edits1dAgoV2{"edits_1d_ago_v2"sv, name_};
    static constexpr NullableInt64Column edits7dAgoV2{"edits_7d_ago_v2"sv, name_};
    static constexpr NullableInt64Column edits30dAgoV2{"edits_30d_ago_v2"sv, name_};
    static constexpr NullableInt64Column edits90dAgoV2{"edits_90d_ago_v2"sv, name_};
    static constexpr NullableTimePointColumn firstCommitAt{"first_commit_at"sv, name_};

    static constexpr auto columns_() {
        return std::tie(
            uid, totalEdits, totalEditsV2, oldRatingPosCreated, oldRatingPosEdits,
            edits1dAgoV2, edits7dAgoV2, edits30dAgoV2, edits90dAgoV2,
            firstCommitAt
        );
    }
};

struct CatGroupEditsStatTbl : Table<CatGroupEditsStat>
{
    static constexpr std::string_view name_{"social.cat_group_edits_stat"};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr Int64Column uid{"uid"sv, name_};
    static constexpr StringColumn categoryGroup{"category_group"sv, name_};
    static constexpr Int64Column totalCount{"total_count"sv, name_};
    static constexpr Int64Column createdCount{"created_count"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, uid, categoryGroup, totalCount, createdCount);
    }
};

} // namespace table

using TotalEditsStatGateway = sql_chemistry::Gateway<table::TotalEditsStatTbl>;
using CatGroupEditsStatGateway = sql_chemistry::Gateway<table::CatGroupEditsStatTbl>;

} // namespace maps::wiki::social
