#pragma once

#include <yandex/maps/wiki/social/common.h>

#include <pqxx/pqxx>

#include <vector>
#include <cstdint>

namespace maps::wiki::social {

class Factory;

class EventAlert
{
public:
    EventAlert(TId eventId, uint32_t priority, std::string description, TId objectId);

    TId eventId() const { return eventId_; }
    uint32_t priority() const { return priority_; }
    const std::string& description() const { return description_; }
    TId objectId() const { return objectId_; }

private:
    friend Factory;

    explicit EventAlert(const pqxx::row& row);

    TId eventId_;
    uint32_t priority_;
    std::string description_;
    TId objectId_;
};

using EventAlerts = std::vector<EventAlert>;

} //namespace maps::wiki::social
