#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/moderation.h>

#include <optional>

namespace maps::wiki::social {

class EventFilter
{
    #define FILTER(T, name)                              \
    public:                                              \
        EventFilter& name(T name);                       \
        const std::optional<T>& name() const noexcept;   \
    private:                                             \
        std::optional<T> name##_;

    // Affects both commit and feedback events
    FILTER(TId, aoiId);
    FILTER(TId, createdBy);
    FILTER(TId, resolvedBy);
    FILTER(EventType, eventType);
    FILTER(ModerationMode, moderationMode);
    FILTER(Deferred, deferred);

    // Affects only commit events
    FILTER(TId, objectId);
    FILTER(CategoryIdsSet, categoryIds);
    FILTER(bool, commonTasksPermitted);
    FILTER(bool, suspiciousUsers);
    FILTER(bool, noviceUsers);
    FILTER(TIds, commitIds);

    #undef FILTER

public:
    // Affects only feedback events
    EventFilter& areFeedbackTasksPermitted(bool permitted);
    bool areFeedbackTasksPermitted() const;
private:
    bool areFeedbackTasksPermitted_ = false;
};

} // namespace maps::wiki::social
