#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/json/include/value.h>

#include <pqxx/pqxx>
#include <optional>
#include <vector>

namespace maps::wiki::social {

class FbapiIssueFilter
{
public:
    std::string whereClause() const;
    FbapiIssueFilter& feedbackTaskId(TId feedbackTaskId) {
        feedbackTaskId_ = feedbackTaskId; return *this; }
    FbapiIssueFilter& issueIds(std::set<std::string> issueIds) {
        issueIds_ = std::move(issueIds); return *this; }

private:
    std::optional<TId> feedbackTaskId_;
    std::optional<std::set<std::string> > issueIds_;
};

class FbapiIssue;
using FbapiIssues = std::vector<FbapiIssue>;

class FbapiIssue
{
public:
    TId id() const { return id_; }
    chrono::TimePoint createdAt() const { return createdAt_; }
    const std::string& issueId() const { return issueId_; }
    TId feedbackTaskId() const { return feedbackTaskId_; }
    const json::Value& rawData() const { return rawData_; }

private:
    friend class Factory;
    explicit FbapiIssue(const pqxx::row& row);

    TId id_;
    chrono::TimePoint createdAt_;
    std::string issueId_;
    TId feedbackTaskId_;
    json::Value rawData_;
};

FbapiIssues fbapiIssuesByFilter(
    pqxx::transaction_base& socialTxn,
    const FbapiIssueFilter& filter);

FbapiIssues fbapiIssuesUnmatchedHash(
    pqxx::transaction_base& socialTxn);

std::optional<FbapiIssue> fbapiIssueById(
    pqxx::transaction_base& socialTxn,
    TId issueId);

FbapiIssue addFbapiIssue(
    pqxx::transaction_base& socialTxn,
    const std::string& issueId,
    TId feedbackTaskId,
    const json::Value& rawData);

FbapiIssue updateFbapiIssueHashValue(
    pqxx::transaction_base& socialTxn,
    TId issueId,
    const std::string& newHashValue);

} // namespace maps::wiki::social
