#pragma once
#include <yandex/maps/wiki/social/i_feed.h>

#include <yandex/maps/wiki/social/feed_filter.h>

#include <maps/libs/chrono/include/time_point.h>
#include <yandex/maps/wiki/social/common.h>

#include <yandex/maps/wiki/social/feed_type.h>
#include <yandex/maps/wiki/social/feed_action.h>

#include <pqxx/pqxx>

namespace maps::wiki::social {

class Feed : public IFeed
{
public:
    Feed(
        pqxx::transaction_base& work,
        TId branchId,
        TId subscriberId,
        FeedType feedType,
        FeedFilter filter);

    Feed(
        pqxx::transaction_base& work,
        TId branchId,
        TId subscriberId,
        FeedType feedType);

    Feed(
        pqxx::transaction_base& work,
        TId branchId,
        FeedType feedType,
        FeedFilter filter);

    TId branchId() const { return branchId_; }
    TId subscriberId() const { return subscriberId_; }
    FeedType feedType() const { return feedType_; }

    const CategoryIdsFilter& categoryIdsFilter() const override { return filter_.categoryIds_; }
    void setCategoryIdsFilter(CategoryIdsFilter categoryIdsFilter) override { filter_.categoryIds_ = std::move(categoryIdsFilter); }

    size_t count() const override;
    size_t limitedCount(size_t maximum) const;

    Events events(size_t offset, size_t limit) const override;

    std::pair<Events, HasMore> eventsHead(size_t limit)                const override;
    std::pair<Events, HasMore> eventsAfter(TId eventId, size_t limit)  const override;
    std::pair<Events, HasMore> eventsBefore(TId eventId, size_t limit) const override;

private:
    void whereClause(std::ostream& os) const;

    pqxx::transaction_base& work_;
    const TId branchId_;
    const TId subscriberId_;
    const FeedType feedType_;

    FeedFilter filter_;
};

} // namespace maps::wiki::social
