#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/feed_action.h>

#include <optional>
#include <utility>
#include <vector>

namespace maps::wiki::social {

class FeedFilter {
public:
    FeedFilter& createdAfter(chrono::TimePoint timePoint) { createdAfter_ = timePoint; return *this; }
    FeedFilter& createdBefore(chrono::TimePoint timePoint) { createdBefore_ = timePoint; return *this; }
    FeedFilter& actionsAllowed(const std::vector<FeedAction>& actions) { actions_ = actions; return *this; }
    FeedFilter& createdBy(const std::vector<TUid>& uids) { creatorIds_ = uids; return *this; }
    FeedFilter& feedRegion(const std::string& geomWkb) { feedRegionGeomWkb_ = geomWkb; return *this; }
    FeedFilter& categoryIds(const CategoryIdsFilter& categoryIdsFilter) { categoryIds_ = categoryIdsFilter; return *this; }
    FeedFilter& commitIds(const TIds& commitIds) { commitIds_ = commitIds; return *this; }

private:
    friend class Feed;
    friend class Gateway;

    std::optional<chrono::TimePoint> createdAfter_;
    std::optional<chrono::TimePoint> createdBefore_;
    std::vector<FeedAction> actions_;
    std::vector<TUid> creatorIds_;
    std::optional<std::string> feedRegionGeomWkb_;
    CategoryIdsFilter categoryIds_{{}, InclusionPolicy::Excluding}; // Exclude nothing by default.
    TIds commitIds_;
};

} // namespace maps::wiki::social
