#pragma once

#include <string>

namespace maps::wiki::social::feedback::attrs {

// common
const std::string COMMIT_ID = "commitId";
const std::string OBJECT_DIFF = "objectDiff";
const std::string SOURCE_CONTEXT = "sourceContext";
const std::string USER_COMMENT = "userComment";
const std::string USER_EMAIL = "userEmail";
const std::string ATTRS = "attrs";
const std::string USER_DATA = "userData";
const std::string SUBSOURCE = "subsource";
const std::string FROM_PUSH = "fromPush";
const std::string OBJECT_URI = "objectUri";

// personal data
const std::string IP = "ip";
const std::string FINGERPRINT = "fingerprint";
const std::string UID = "uid";
const std::string USER_AGENT = "userAgent";
const std::string YANDEXUID = "yandexuid";

// action
const std::string SUGGESTED_ACTION = "suggestedAction";

// wrong-speed-limit
const std::string CURRENT_SPEED_LIMIT = "currentSpeedLimit";
const std::string CORRECT_SPEED_LIMIT = "correctSpeedLimit";
const std::string DIRECTION = "direction";
const std::string TRUCK = "truck";
const std::string CONFIRMING_SIGN_NOT_FOUND = "confirmingSignNotFound";

// entrance
const std::string ENTRANCE_NAME = "entranceName";

// wrong-road-direction
const std::string SUPPOSED_DIRECTION = "supposedDirection";

// absent parking
const std::string PARKING_TOLL = "toll";

// parking-ft
const std::string CURRENT_FT_TYPE = "currentFtType";
const std::string CORRECT_FT_TYPE = "correctFtType";

// wrong-address
const std::string STREET = "street";
const std::string HOUSE = "house";

// route-lost
const std::string BEFORE_LOST_SEGMENT = "beforeLostSegment";
const std::string AFTER_LOST_ROUTE_SEGMENT = "afterLostRouteSegment";
const std::string AFTER_LOST_TRACK_SEGMENT = "afterLostTrackSegment";
const std::string EDGE_ID = "edgeId";
const std::string SEGMENT_ID = "segmentId";

// absent address
const std::string ADDRESS_HOUSE_NUMBER = "addressHouseNumber";

// userData
const std::string USER_DATA_COMMENT = "userDataComment";
const std::string USER_DATA_SEARCH_REQUEST = "userDataSearchRequest";
const std::string USER_DATA_PHOTO_URLS = "userDataPhotoUrls";

// poi
const std::string POI_ENTRANCES = "poiEntrances";

// prohibited path
const std::string ACCESS_ID = "accessId";
const std::string COND_TYPE = "condType";

// speed bump
const std::string SPEED_BUMP_AHEAD = "ahead";

} // namespace maps::wiki::social::feedback::attrs
