#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/json/include/value.h>
#include <unordered_map>

namespace maps::wiki::social::feedback {

enum class AttrType
{
    SourceContext,
    ObjectDiff,
    UserData,
    UserDataPhotoUrls,
    PoiEntrances,
};

DECLARE_ENUM_IO(AttrType);

class Attrs
{
public:
    Attrs() = default;
    Attrs(const json::Value& json);

    json::Value toJson() const;

    void add(AttrType type, json::Value value);
    bool exist(AttrType type) const;
    const json::Value& get(AttrType type) const;

    void addCustom(const std::string& name, const std::string& val);
    void setFlag(const std::string& name, bool flag = true);
    bool existCustom(const std::string& name) const;
    const std::string& getCustom(const std::string& name) const;
    bool getFlag(const std::string& name) const;

private:
    std::unordered_map<AttrType, json::Value> predefinedAttrs_;
    std::unordered_map<std::string, std::string> customAttrs_;
};

} // namespace maps::wiki::social::feedback
