#pragma once

#include <yandex/maps/wiki/social/common.h>

#include <pqxx/pqxx>
#include <unordered_map>

namespace maps::wiki::social::feedback {

TIds commitIdsByTaskId(
    pqxx::transaction_base& socialTxn,
    TId taskId);

// taskId -> [commitId, ..]
std::unordered_map<TId, TIds> commitIdsByTaskIds(
    pqxx::transaction_base& socialTxn,
    TIds taskIds);

void bindCommitsToTask(
    pqxx::transaction_base& socialTxn,
    TId taskId,
    const TIds& commitIds);

// commitId -> taskId
std::unordered_map<TId, TId> taskIdsByCommitIds(
    pqxx::transaction_base& socialTxn,
    TIds commitIds);

} // namespace maps::wiki::social::feedback
