#pragma once

#include <map>
#include <string>
#include <variant>

namespace maps::wiki::social::feedback {

class Description;
using ParamToDescription = std::map<std::string, Description>;


class DescriptionI18n
{
public:
    explicit DescriptionI18n(std::string i18nKey, ParamToDescription i18nParams = {});

    const std::string& i18nKey() const;
    const ParamToDescription& i18nParams() const;

    bool operator == (const DescriptionI18n& other) const;

private:
    std::string i18nKey_;
    ParamToDescription i18nParams_;
};


class Description
{
public:
    Description();
    Description(std::string nonTranslatable);
    Description(DescriptionI18n translatable);

    bool isNonTranslatable() const;
    bool isTranslatable() const;

    const std::string& asNonTranslatable() const;
    const DescriptionI18n& asTranslatable() const;

    bool operator == (const Description& other) const;

private:
    std::variant<std::string, DescriptionI18n> repr_;
};

} //namespace maps::wiki::social::feedback
