#pragma once

#include <maps/libs/json/include/builder.h>
#include <maps/libs/json/include/value.h>

namespace maps::wiki::social::feedback {

const std::string I18N_KEY = "i18nKey";
const std::string I18N_PARAMS = "i18nParams";

class Description;
class DescriptionI18n;

template<typename T>
T fromJson(const json::Value& json);

template<>
Description fromJson(const json::Value& json);

template<>
DescriptionI18n fromJson(const json::Value& json);

void json(const Description& desc, json::VariantBuilder builder);
void json(const DescriptionI18n& desc, json::VariantBuilder builder);

std::string toJson(const Description& desc);
std::string toJson(const DescriptionI18n& desc);

} //namespace maps::wiki::social::feedback
