#pragma once

#include <yandex/maps/wiki/social/feedback/task.h>
#include <yandex/maps/wiki/social/feedback/gateway_rw.h>
#include <optional>

namespace maps::wiki::social::feedback {

/// Bind all trees containing tasks with id from <ids>
/// into new one tree.
/// The task with most left status selected as head
/// and is returned as result.
///
/// @returns headTask
std::optional<TaskForUpdate> bindDuplicates(
    GatewayRW& gatewayRw,
    TUid uid,
    TIds ids);

TaskForUpdate changeHeadStatusAccordingToDuplicates(
    GatewayRW& gatewayRw,
    TUid uid,
    const TaskForUpdate& headTask);

void changeDuplicatesStatusesAccordingToHead(
    GatewayRW& gatewayRw,
    TUid uid,
    const TaskForUpdate& headTask);

} //namespace maps::wiki::social::feedback
