#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <map>
#include <set>
#include <vector>

namespace maps::wiki::social::feedback {

enum class TaskState
{
    Incoming,
    Deferred,
    Opened,
    NeedInfo,
    Accepted,
    Rejected,
    Deployed,
};
DECLARE_ENUM_IO(TaskState);

enum class UIFilterStatus
{
    Opened,
    NeedInfo,
    Resolved,
};
DECLARE_ENUM_IO(UIFilterStatus);

enum class Verdict
{
    Accepted,
    Rejected
};

DECLARE_ENUM_IO(Verdict);

enum class RejectReason
{
    AutoCleanWeb, // Автоматическое отклонение чистым вебом
    IncorrectData, // Ошибочная информация
    NoData, // Недостаточно информации для исправления
    NoInfo, // Противоречивая информация
    NoProcess, // obsolete
    ProhibitedByRules,
    RedirectToContentAuto,
    RedirectToContentBicycle,
    RedirectToContentBigTask,
    RedirectToContentMasstransit,
    RedirectToContentOther,
    RedirectToContentPedestrian,
    RedirectToContentRoadEvents,
    RedirectToContentToponym,
    RedirectToContentTruck,
    RedirectToPlatformAuto,
    RedirectToPlatformBicycle,
    RedirectToPlatformMasstransit,
    RedirectToPlatformToponym,
    RedirectToPlatformTruck,
    RedirectToSprav,
    RedirectToSupport,
    Spam,
};

DECLARE_ENUM_IO(RejectReason);
using RejectReasonsSet = std::set<RejectReason>;


enum class Bucket
{
    Outgoing,
    Incoming,
    Deferred,
    NeedInfo
};

DECLARE_ENUM_IO(Bucket);
using Buckets = std::vector<Bucket>;
Buckets allRevealedBuckets();


enum class AgeType
{
    Old,
    New
};

DECLARE_ENUM_IO(AgeType);
using AgeTypes = std::vector<AgeType>;
AgeTypes allAgeTypes();

enum class Movement {
    Forward,
    LeftTurn,
    RightTurn,
    Uturn,
};

DECLARE_ENUM_IO(Movement);

enum class SuggestedAction
{
    Modify,
    Delete,
    CreateIndoorPoi,
    CreatePoi,
    VerifyPosition
};

DECLARE_ENUM_IO(SuggestedAction);


enum class Workflow
{
    Feedback,
    Task
};

DECLARE_ENUM_IO(Workflow);
using Workflows = std::vector<Workflow>;
Workflows allWorkflows();


enum class ProcessingLvl
{
    Level0,
    Level1,
    Level2,
    BigTask,
};

DECLARE_ENUM_IO(ProcessingLvl);
using ProcessingLvls = std::vector<ProcessingLvl>;
using ProcessingLvlSet = std::set<ProcessingLvl>;


enum class Type
{
    // Category Road
    Road,
    NoRoad,
    StreetName,
    RoadSpeedLimit,
    RoadDirection,
    RoadSurface,
    RouteGap,
    RouteLost,

    // Category Route
    CarRoute,
    PedestrianRoute,
    BicycleRoute,
    MtRoute,
    ScooterRoute,
    TruckRoute,
    TaxiRoute,

    // Category Building
    Building,
    Address,
    AddressExperiment,
    Entrance,
    EntranceExperiment,

    // Category RoadInfrastructure
    Fence,
    PublicTransportStop,
    Parking,
    Maneuver,
    Barrier,
    RoadClosure,
    RoadAnnotation,
    TrafficLight,
    Subway,

    // Category Other
    Other,
    SettlementScheme,
    OtherHeavy,

    // Category Sign
    MandatoryDirectionTrafficSign,
    ProhibitedTurnSign,
    OneWayTrafficSign,
    TrafficLaneSign,
    TrafficProhibitedSign,
    TrafficCircleSign,
    TrucksProhibitedSign,
    TrucksManeuverRestrictionSign,
    TrucksSpeedLimitSign,
    WeightLimitingSign,
    DimensionsLimitingSign,
    SpeedBumpSign,

    ConstructiveSignDisappearance,
    AutomotiveSignDisappearance,
    PedestrianSignDisappearance,
    HeavyVehicleSignDisappearance,
    SpeedLimitSignDisappearance,
    ParkingSignDisappearance,
    PublicTransportSignDisappearance,
    TrafficLanesSignDisappearance,

    // Category Poi
    Indoor,
    Poi,
    Bench,
    Playground,

    // Category Indoor
    IndoorBarrier
};

DECLARE_ENUM_IO(Type);
using Types = std::vector<Type>;
using TypesSet = std::set<Type>;
Types allTypes();

enum class TypeCategory
{
    Roads,
    Routes,
    Buildings,
    RoadInfrastructure,
    Other,
    Signs,
    Poi,
    Indoor
};

DECLARE_ENUM_IO(TypeCategory);
using TypeCats = std::vector<TypeCategory>;
TypeCats allTypeCats();


TypeCategory typeCategoryByType(Type type);
using TypeCatToTypes = std::vector<std::pair<TypeCategory, Types>>;
TypeCatToTypes typeCategoryToTypes();

enum class Column
{
    Workflow,
    Source,
    Type
};
DECLARE_ENUM_IO(Column);
using Columns = std::set<Column>;

} //namespace maps::wiki::social::feedback
