#pragma once

#include <yandex/maps/wiki/social/feedback/aggregated_counter.h>
#include <yandex/maps/wiki/social/feedback/history.h>
#include <yandex/maps/wiki/social/feedback/task.h>
#include <yandex/maps/wiki/social/feedback/task_feed.h>
#include <yandex/maps/wiki/social/feedback/task_filter.h>

#include <pqxx/pqxx>
#include <optional>

namespace maps::wiki::social::feedback {

using TaskIdsToHistory = std::map<TId, History>;

class GatewayRO
{
public:
    explicit GatewayRO(pqxx::transaction_base& socialTxn);
    virtual ~GatewayRO() {}

    std::optional<Task> taskById(TId id);
    Tasks tasksByIds(TIds ids);
    std::optional<Task> taskByCommitId(TId commitId);
    std::optional<Task> taskByExternalReferenceId(const ExternalReferenceId& id);

    History history(TId taskId);
    TaskIdsToHistory history(const TIds& taskIds);

    size_t getTotalCountOfTasks(const TaskFilter& filter);
    std::vector<AggregatedCounter> getAggregatedCountOfTasks(
        const TaskFilter& filter,
        const Columns& aggregationColumns);

    TIds taskIdsByFilter(const TaskFilter& filter);
    Tasks tasksByFilter(const TaskFilter& filter);
    TasksBriefResult tasksBriefByFilter(const TaskFilter& filter, std::optional<size_t> limit);
    TaskFeed tasksFeed(
        const TaskFilter& filter, const ITaskFeedParams& feedParams);
    TaskFeedWithCount tasksFeedWithCount(
        const TaskFilter& filter, const ITaskFeedParams& feedParams);

    size_t countOperationsToday(const TaskOperations& operations, TUid uid, int tzOffsetInMinutes);

protected:
    std::string taskIdsByFilterQuery(const TaskFilter& filter);
    std::string tasksByFilterQuery(const TaskFilter& filter, std::optional<size_t> limit = std::nullopt);

    pqxx::transaction_base& socialTxn_;
};

} // namespace maps::wiki::social::feedback
