#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/feedback/description.h>
#include <yandex/maps/wiki/social/feedback/gateway_ro.h>
#include <yandex/maps/wiki/social/feedback/task_new.h>
#include <yandex/maps/wiki/social/feedback/task_patch.h>

#include <pqxx/pqxx>
#include <optional>

namespace maps::wiki::social::feedback {

class GatewayRW : public GatewayRO
{
public:
    explicit GatewayRW(pqxx::transaction_base& socialTxn);

    TaskForUpdate addTask(TUid uid, const TaskNew& newTask);

    TasksForUpdate tasksForUpdateByIds(TIds ids);
    std::optional<TaskForUpdate> taskForUpdateById(TId id);
    TasksForUpdate tasksForUpdateByFilter(const TaskFilter& filter);

    std::optional<TaskForUpdate> updateTaskById(TId id, const TaskPatch& patch);
    TaskForUpdate updateTask(const TaskForUpdate& task, const TaskPatch& patch);

    void updateDuplicatedHeadId(TUid uid, const TIds& ids, const TId& headIdNew);
    void releaseOverdueTasks(TUid uid);

    pqxx::transaction_base& txn() { return socialTxn_; }
};

} // namespace maps::wiki::social::feedback
